varying vec4 lmtexcoord;
varying vec4 color;
varying vec2 normalMatCompressed;

vec3 normalMat = decodeNormal(normalMatCompressed);


vec3 calculateNormalWrapper(vec3 fragpos)
{
    vec3 normal = normalMat;

#ifdef NORMAL_FIX
    // This section is only executed if NORMAL_FIX is enabled
    vec3 cameraVector = normalize(fragpos);
    vec3 vnormal = worldToView(normalMat);
    normal = viewToWorld(faceforward(worldToView(normal), cameraVector, vnormal));
#endif

    return normal;
}

#ifdef NO_ENTITY_TAA
/* RENDERTARGETS: 0,2,3,5 */
#else
/* RENDERTARGETS: 0,2,3 */
#endif
void main()
{
    vec2 tcoord = lmtexcoord.xy;
    vec2 lightmap = lmtexcoord.zw;

    // If toScreenSpace is just a scale/bias, keep it; else, precompute in vertex if possible.
    vec3 fragpos = toScreenSpace(gl_FragCoord.xyz * vec3(texelSize, 1.0));

    // Fetch base color
    vec4 albedo = texture(texture, tcoord, 0);
    albedo.rgb *= color.rgb;

    if (entityId == 1600)
    {
        albedo.a *= color.a;
        lightmap.y = 0.92;
    }
    albedo.rgb = mix(albedo.rgb, entityColor.rgb, entityColor.a);

    vec3 normal = calculateNormalWrapper(fragpos);

    float ao = color.a;
#ifdef NAMETAG_FIX

    if (entityId == 1500)
    {
        albedo.a *= color.a;
        ao = 1.0;
        albedo.rgb *= 2.0;
    }
#endif
    // Linearize only once, after all blends
    albedo.rgb = toLinear(albedo.rgb);

    gl_FragData[0] = albedo;
    gl_FragData[1].rgba = vec4(encodeNormal(normal), encodeVec2(lightmap), encodeVec2(vec2(ao, 0.0)));
    gl_FragData[2].r = 0.0;

#ifdef NO_ENTITY_TAA
    gl_FragData[3].g = 1.0;
#endif
}
